<?php

/**
 * @file
 * The file containing the helper functions for most of the functionality that is provided
 * by the API
 *
 */

define('DEFAULT_RESULTS_PER_PAGE', 50);
define('AUTOMATR_CONTACT_PATH', 'https://a.volacciapp.com/data/public/Contact/setup?intContactId=');


function volacci_extra_get_all_records($controller, $method, $id_key, $value_key, $return_key_value = TRUE) {
  global $automatr_api_obj;
  $cache_id = 'volacci_extra_get_all_' . $controller . '_' . $method;
  if ($cached = cache_get($cache_id, 'cache_automatr')) {
    $full_list_key_values = $cached->data;
  }
  if (empty($full_list_key_values)) {
    $full_list = array();
    $full_list_key_values = array();
    try {
      $response = $automatr_api_obj->call_method($controller, $method);
      $total_records = $response->result->totalRecords;
      if ($total_records > 0) {
        // Define items per call
        $num_per_page = DEFAULT_RESULTS_PER_PAGE;
        // Loop through all alerts
        for ($i = 0; $i < ceil($total_records/$num_per_page); $i++) {
          $offset = ($i) * $num_per_page;
          $response = $automatr_api_obj->call_method($controller, $method, array('offset' => $offset, 'limit' => $num_per_page));
          $full_list = array_merge($full_list, $response->result->results);
        }
        if ($return_key_value) {
          foreach ($full_list as $values) {
            $full_list_key_values[$values->{$id_key}] = $values->{$value_key};
          }
        }
      }
      else {
        drupal_set_message(t("List is empty ! Contact Administrator.."));
      }
    } catch (Exception $e) {
        drupal_set_message($e->getMessage(), 'error');
    }
  }
  if (!$return_key_value) {
    cache_set($cache_id, $full_list, 'cache_automatr', get_automatr_cache_ttl_value());
    return $full_list;
  }
  cache_set($cache_id, $full_list_key_values, 'cache_automatr', get_automatr_cache_ttl_value());
  return $full_list_key_values;
}

/*
 * Function to get all Custom Fields
 */

function volacci_extra_get_all_custom_contact_fields() {
  return volacci_extra_get_all_records('CustomAttribute', 'getMultiple', 'custom_attribute_id', 'custom_attribute');
}

/*
 * Function to get all Domain Groups
 */

function volacci_extra_get_all_domain_groups() {
  $class = 'DomainGroup';
  $method = 'getAll';
  $params = array(
  );
  global $automatr_api_obj;
  try{
    $response = $automatr_api_obj->call_method($class, $method, $params);
  }catch (Exception $e) {
    watchdog('Automatr', t('Unable to fetch domain groups'), array(), WATCHDOG_ERROR);
  }
  $domains = get_key_value_from_results($response->result, 'domain_group_id', 'domain_group_name');
  return $domains;
}

/*
 * Function to get Unsegmented Contact Activity of a Contact
 */

function volacci_extra_get_unsegmented_contact_activity($contact_id, $domain_group_id, $start_date = NULL, $end_date = NULL) {
  $class = 'Visit';
  $method = 'getUnsegmentedContactDetail';
  $params = array(
		  'contact_id' => $contact_id,
		  'domain_group_id' => $domain_group_id,
		  'start_date' => $start_date,
		  'stop_date' => $end_date,
  );
  global $automatr_api_obj;
  try{
    $response = $automatr_api_obj->call_method($class, $method, $params);
    return $response;
  }catch (Exception $e) {
    watchdog('Automatr', t('Unable to fetch contact activity') . $e->getMessage(), array(), WATCHDOG_ERROR);
  }
}

function volacci_automatr_get_one_contact($contact_id) {
  if ($contact_id == '') {
    $contact_id = get_contact_id_for_current_user();
  }
  $params = array(
    'contact_id' => $contact_id
  );
  if (isset($_SESSION['automatr_contactid']['value']) && $contact_id == $_SESSION['automatr_contactid']['value']) {
    if (isset($_SESSION['automatr_contact_response']['value'])) {
      return $_SESSION['automatr_contact_response']['value'];
    }
  }
  global $automatr_api_obj;
  $response = $automatr_api_obj->call_method('Contact', 'getOne', $params);
  if (!isset($reponse->error) && isset($_SESSION['automatr_contactid']['value']) && ($contact_id == $_SESSION['automatr_contactid']['value'])) {
    $_SESSION['automatr_contact_response']['value'] = $response;
    $_SESSION['automatr_contact_response']['time'] = time();
  }
  return $response;
}

function volacci_automatr_get_contact_by_email($email) {
  $class = 'Contact';
  $method = 'getContactIdByEmailAddress';
  $params = array(
    'email_address' => $email
  );
  global $automatr_api_obj;
  return $automatr_api_obj->call_method($class, $method, $params);
}


function volacci_automatr_get_contact_activity($contact_id, $offset = '0', $limit_value = LIMIT_VALUE, $order_by = 'contact_activity_history_date', $order_dir = 'DESC', $extra_params = array()) {
  $class = 'ContactActivityHistory';
  $method = 'getContactActivity';
  if(!isset($params['activity_type'])){
    $params['activity_type'] = '';
  }
  $filters = array('contact_activity_history_type_id' => $extra_params['activity_type'] );
  $params = array(
    'contact_id' => $contact_id,
    'offset' => $offset,
    'limit' =>  $limit_value,
    'order_by' => $order_by,
    'order_dir' => $order_dir,
    'filters' => $filters,
  );
  global $automatr_api_obj;
  return $automatr_api_obj->call_method($class, $method, $params);

}

function volacci_automatr_get_contact_activity_types() {
  $class = 'ContactActivityHistory';
  $method = 'getTypes';
  $params = array();
  global $automatr_api_obj;
  return $automatr_api_obj->call_method($class, $method, $params);
}


function volacci_automatr_get_contact_activity_types_array() {
  try{
    $response = volacci_automatr_get_contact_activity_types();
  }catch (Exception $e) {
    watchdog('Automatr', t('Unable to fetch acitvity types'), array(), WATCHDOG_ERROR);
  }
  $types = get_value_from_results($response->result, 'text');
  return $types;
}


/*
 * Function to get the list of custom contact field labels
 */
function volacci_extra_get_custom_contact_field_labels() {
  $response = volacci_extra_get_all_custom_contact_fields();
  $field_labels = array();
  foreach ($response as $result) {
    $field_labels[$result] = $result;
  }
  return $field_labels;
}

/*
 * Function to get the list of custom contact field array
 */
function volacci_extra_get_custom_contact_fields_array() {
  global $automatr_api_obj;
  $response = $automatr_api_obj->call_method('CustomAttribute', 'getMultiple');
  $field_array = array();
  foreach ($response->result->results as $result) {
    $field_array[$result->custom_attribute_id] = $result->custom_attribute;
  }
  return $field_array;
}


/*
 * Function to get all segments key value pairs for list
 */

function volacci_extra_get_all_segments() {
  return volacci_extra_get_all_records('ContactSegment', 'getMultiple', 'contact_segment_id', 'contact_segment_name');
}

/**
 *    Function to get default segment
 */

function volacci_extra_get_default_segment() {
  $full_segment = volacci_extra_get_all_records('ContactSegment', 'getMultiple', 'contact_segment_id', 'contact_segment_name', false);
  foreach ($full_segment as $values) {
    if ($values->contact_segment_default == 1) {
      return $values->contact_segment_id;
    }
  }
  return '';
}

/*
 * Function to get all lists
 */

function volacci_extra_get_all_lists() {
  return volacci_extra_get_all_records('EmailList', 'getMultiple', 'email_list_id', 'email_list_name');
}


/*
 * Function to get key value pair from the results array
 */

function get_key_value_from_results($array_of_objects, $key_attribute, $value_attribute) {
  $results_array = array();
  foreach ($array_of_objects as $result) {
    $result = (array) $result;
    $results_array[$result[$key_attribute]] = $result[$value_attribute];
  }
  return $results_array;
}

/*
 * Function to get key value pair from the results array
 */

function get_value_from_results($array_of_objects, $value_attribute) {
  $results_array = array();
  foreach ($array_of_objects as $key => $result) {
    $result = (array) $result;
    $results_array[$key] = $result[$value_attribute];
  }
  return $results_array;
}

/**
 * Returns the folder list of volacci
 * @return type
 */
function get_folder_list() {
  global $automatr_api_obj;
  $dash = '-';
  $class = 'FolderEmailList';
  $method = 'getFolderTree';
  $params = array();
  $folders = $automatr_api_obj->call_method($class, $method, $params);
  if (!empty($folders->result)) {
    $folder_list = get_branch_folders($folders->result, $dash);
  }
  return iterator_to_array(new RecursiveIteratorIterator(new RecursiveArrayIterator($folder_list)), TRUE);
}

/**
 * Recursive function to get the sub-folders
 * @param type $folders
 * @param string $dash
 * @return type
 */
function get_branch_folders($folders, $dash) {
  foreach ($folders as $folder) {
    if (!$folder->is_root) {
      $folder_name = $dash . $folder->folder_name;
    }
    else {
      $folder_name = $folder->folder_name;
    }
    $folder_list[$folder->folder_id] = $folder_name;
    if (isset($folder->branches)) {
      $dash .= '-';
      $folder_list[] = get_branch_folders($folder->branches, $dash);
    }
  }
  return $folder_list;
}

/*
 * Function to get lead overlay score
 */

function volacci_extra_get_lead_overlay_score($contact_id, $overlay_id) {
  global $automatr_api_obj;
  $class = 'Contact';
  $method = 'getOneWithScore';
  $params = array(
    'contact_id' => $contact_id,
    'overlay_id' => $overlay_id,
  );
  $response = $automatr_api_obj->call_method($class, $method, $params);
  return $response;
}


/*
 * Function to get all Reports
 */

function volacci_extra_get_all_reports() {
  return volacci_extra_get_all_records('Report', 'getMultiple', 'report_id', 'report_name');
}

function volacci_extra_get_custom_fields_for_contact($contct_id) {
  global $automatr_api_obj;
  $class = 'CustomAttribute';
  $method = 'getByContact';
  $params = array(
    'contact_id' => $contct_id,
  );
  $response = $automatr_api_obj->call_method($class, $method, $params);
  return $response;
}


//To check wether the entered credentials are correct or not
function check_credentails($username, $password) {
  global $automatr_api_obj;
  $class = 'User';
  $method = 'getOneByEmail';
  $params = array(
    'email' => $username,
  );
  $response = $automatr_api_obj->call_method($class, $method, $params);
  return $response;
}


/**
 * Default fields for exporting users and syncing to volacci
 * @return string
 */
function volacci_default_fields() {
  $volacci_automatr_default_fields = array('no_mapping' => 'No Mapping', 'address_1' => 'Address1', 'address_2' => 'Address2',
    'company' => 'Company Name', 'first_name' => 'First Name', 'last_name' => 'Last Name',
    'title' => 'Title', 'city' => 'City', 'state' => 'State', 'contact_postalcode' => 'Zip', 'country' => 'Country', 'lead_status_id' => 'Lead Stage',
    'home_phone' => 'Home Phone', 'work_phone' => 'Work Phone', 'mobile_phone' => 'Mobile Phone',
    'fax' => 'Fax', 'ip_address' => 'IP Address', 'user_id' => 'Lead Owner');
  return $volacci_automatr_default_fields;
}

/*
 * Function to get user membership lists : TODO
 */


function volacci_extra_get_contact_membership_lists($contact_id) {
  try {
    $response = volacci_extra_get_mailing_info_for_contact($contact_id);
  }catch (Exception $e) {
  }
  $lists = $response->result->email_lists;
  if (!isset($lists)) {
    return array();
  }
  $lists_array = array();
  foreach ($lists as $key => $list) {
    $lists_array[$list->email_list_id] = $list->email_list_name;
  }
  return $lists_array;
}


/*
 * Function to get user contact segments :TODO
 */


function volacci_extra_get_contact_segments($contact_id) {
  $class = 'Contact';
  $method = 'getEmailListMembershipConfiguration';
  $params = array(
    'intContactId' => $contact_id,
  );
  global $automatr_api_obj;
  $response = $automatr_api_obj->call_method($class, $method, $params);

  return $response;
}

/*
 * Function to get user lead scores
 */
function volacci_extra_get_user_lead_scores() {
  $class = 'LeadScoreOverlay';
  $method = 'getAll';
  $params = array();
  global $automatr_api_obj;
  $response = $automatr_api_obj->call_method($class, $method, $params);
  $lead_scores = array();
  foreach ($response->result as $lead_score) {
    if ($lead_score->lead_score_overlay_default == 1) {
      $lead_scores[$lead_score->lead_score_overlay_id] = $lead_score->lead_score_overlay_name;
    }
  }
  return $lead_scores;
}

/*
 * Function to get Email Lists
 */
function volacci_extra_get_mailing_info_for_contact($contact_id) {
  $class = 'Contact';
  $method = 'getMailingInfo';
  $params = array(
    'contact_id' => $contact_id,
  );
  global $automatr_api_obj;
  $response = $automatr_api_obj->call_method($class, $method, $params);
  return $response;
}

/*
 * Function check segment membership
 */
function volacci_extra_is_contact_in_segment($contact_id, $segment_id) {
  $class = 'ContactSegment';
  $method = 'getContactParticipation';
  $params = array(
    'contact_id' => $contact_id,
    'contact_segment_id' => $segment_id,
  );
  global $automatr_api_obj;
  $response = $automatr_api_obj->call_method($class, $method, $params);
  return $response->result;
}
/*
 * Function to get contact id from Mauuid
 */
function volacci_extra_get_contactid_from_mauuid($mauuid = '') {
  if ($mauuid == '') {
    if (isset($_COOKIE['__mauuid'])) {
      $mauuid = $_COOKIE['__mauuid'];
    }
    else{
      throw new Exception('Autaomtr cookie is not set. Please contact the site administrator');
    }
  }
  $class = 'Contact';
  $method = 'getContactIdByMauuid';
  $params = array(
    'mauuid' => $mauuid,
  );
  global $automatr_api_obj;
  $contact_id = 0;
  $n = 1;

  while (($contact_id == 0 || $contact_id == '')&& ($n <5)) {
    try{
      $response = $automatr_api_obj->call_method($class, $method, $params);
      $contact_id = $response->result->contact_id;
      if($contact_id) {
	return $response;
      }
    }catch (Exception $e) {
      watchdog('Automatr', t('Failed to get the contact number in Attempt ' . $n), array(), WATCHDOG_ERROR);
      time_nanosleep(2^$n, rand(0,1000000000));
    }
    $n++;
  }
  watchdog('Automatr', t('Unable to find the user on Automatr. The MAUID is !mauuid', array('!mauuid' => $_COOKIE['__mauuid'])), array(), WATCHDOG_ERROR);
}

function get_contact_id_for_current_user($force_new = FALSE) {
  if (!$force_new && isset($_SESSION['automatr_contactid']['value'])) {
    return $_SESSION['automatr_contactid']['value'];
  }

  try {
    $response = volacci_extra_get_contactid_from_mauuid();
    $contact_id = $response->result->contact_id;
    if ($contact_id == '') {
      global $user;
      if ($user->uid > 0) {
        $response = volacci_automatr_get_contact_by_email($user->mail);
        $contact_id = $response->result->contact_id;
	if ($contact_id == '') {
	  throw new Exception('Unable to find the current user in Autaomtr, with the given emailid of Drupal instance');
	}
      }
      else{
        throw new Exception('Unable to find the current anonymous user in Autaomtr');
      }
    }
    $_SESSION['automatr_contactid']['value'] = $contact_id;
    $_SESSION['automatr_contactid']['time'] = time();
    return $contact_id;
  }catch (Exception $e) {
    watchdog('Automatr', $e->getMessage(), array(), WATCHDOG_ERROR);
  }
}

function volacci_get_all_fields() {
  try{
    $volacci_automatr_default_fields = volacci_default_fields();
    $volacci_automatr_custom_fields = volacci_extra_get_custom_contact_fields_array();
    $volacci_automatr_fields = $volacci_automatr_default_fields + $volacci_automatr_custom_fields;
  }catch (Exception $e) {
    watchdog('Automatr', t('Unable to fetch user fields from  Automatr'), array(), WATCHDOG_ERROR);
  }
  return $volacci_automatr_fields;
}

function volacci_get_all_fields_only() {
  try{
    $fields = volacci_get_all_fields();
    unset($fields['no_mapping']);
  }catch (Exception $e) {
    watchdog('Automatr', t('Unable to fetch user fields from  Automatr'), array(), WATCHDOG_ERROR);
  }
  return $fields;
}

function get_automatr_cache_ttl_value() {
  variable_get('automatr_cache', array('frequency' => 86400));
  return $automatr_cache['frequency'];
}

function update_automatr_session_cache() {
  if (isset($_SESSION['automatr_contact_response']['time'])) {
    if ((time() - $_SESSION['automatr_contact_response']['time']) > CACHE_TEMPORARY) {
      unset($_SESSION['automatr_contact_response']);
    }
  }
  if (isset($_SESSION['automatr_contactid']['time'])) {
    if ((time() - $_SESSION['automatr_contactid']['time']) > CACHE_TEMPORARY) {
      unset($_SESSION['automatr_contactid']);
    }
  }
}