<?php

/**
 * @file
 * Function calls related to List in Volacci Automatr
 */


module_load_include('inc', 'volacci_automatr_extra', 'helper');


/**
 * Implements hook_form;
 * Creating Email List
 * @param type $form
 * @param type $form_state
 * @return type
 */
function volacci_extra_email_list_form($form, &$form_state) {
  $form = array();
  try {

    drupal_set_title(t('Create List'));
    $items_list = array(
      array(
        'data' => t('You may create an unlimited number of Lists.')
      ),
      array(
        'data' => t('Each List may have an unlimited number of') . ' ' . l(t('Contacts'), 'http://support.volacciapp.com/index.php/Contacts', array('attributes' => array('external' => TRUE, 'target' => '_blank')))
        . ' ' . t('associated with it.')
      ),
      array(
        'data' => t('Each Contact may be a member of an unlimited number of Lists.')
      ),
      array(
        'data' => t('The number of Lists you create has no impact on your subscription fee.')
      ),
      array(
        'data' => t('You can easily use Lists to perform') . ' '
        . l(t('A/B Split Testing'), 'http://support.volacciapp.com/index.php/A/B_Testing', array('attributes' => array('external' => TRUE, 'target' => '_blank')))
      )
    );
    $form['list_title'] = array(
      '#markup' => "<div class='top-header'>" . l(t('More about Lists.'), 'http://support.volacciapp.com/index.php/Lists', array('attributes' => array('external' => TRUE, 'target' => 'automatr-support'))) . '</div>'
    );
    $form['list_help'] = array(
      '#type' => 'item',
      '#markup' => theme('item_list', array('items' => $items_list))
    );
    $form['list_name'] = array(
      '#title' => t('List Name'),
      '#type' => 'textfield',
      '#prefix' => "<div class = 'single-line-field'>",
      '#suffix' => "</div>"
    );
    $form['store_in_folder'] = array(
      '#type' => 'select',
      '#title' => 'Store in folder',
      '#options' => get_folder_list(),
      '#prefix' => "<div class = 'single-line-field'>",
      '#suffix' => "</div>"
    );
    $form['submit'] = array(
      '#value' => t('Save'),
      '#type' => 'submit',
    );
  } catch (Exception $e) {
    drupal_set_message($e->getMessage(), 'error');
  }
  return $form;
}

/**
 * Implements hook_form_submit;
 * @param type $form
 * @param type $form_state
 */
function volacci_extra_email_list_form_submit($form, &$form_state) {
  try {
    $method = 'setOne';
    $values = $form_state['values'];
    dpm($values['store_in_folder']);
    $email_list = array(
      'email_list_name' => check_plain($values['list_name']),
      'rbac_role_id' => NULL,
      'email_list_folder_id' => $values['store_in_folder'],
    );
    $params = array(
      'email_list' => $email_list,
    );
    $automatr_login = variable_get('automatr_login', array());
    global $automatr_api_obj;
    $response = $automatr_api_obj->call_method('EmailList', $method, $params);
    drupal_set_message(t('The List has been created successfully.'));
  } catch (Exception $e) {
    drupal_set_message($e->getMessage(), 'error');
  }
}

function volacci_automatr_extra_email_list() {
  $email_list = "<div class='top-header'>" . t('Automatr Lists are like "tags" that are used on blogs and other Web 2.0 applications.
                    Because Automatr Segments allow you to filter Contacts based on List membership,
                    you can do some very powerful things with Lists and Segments.')
      . ' ' . l(t('More about Lists.'), 'http://support.volacciapp.com/index.php/Lists', array('attributes' => array('external' => TRUE, 'target' => 'automatr-support'))) . '</div>';
  try {
    global $automatr_api_obj;
    drupal_set_title(t('Email Lists'));
    $method = 'getMultiple';
    $response = $automatr_api_obj->call_method('EmailList', $method);

    $total_records = $response->result->totalRecords;
    $order_by = "email_list_name";
    $sort = "ASC";
    if (isset($_GET['order'])) {
      switch ($_GET['order']) {
        case 'List':
          $order_by = "email_list_name";
        break;
        case 'Size':
          $order_by = "member_count";
        break;
        case 'Mailable Size':
          $order_by = "member_mailable_count";
        break;
        case 'Last Modified':
          $order_by = "last_updated";
        break;
      }
    }

    if (isset($_GET['sort'])) {
      if ($_GET['sort'] == "desc") {
        $sort = "DESC";
      }
    }

    if ($total_records > 0) {
      // Define items per page for paging
      $num_per_page = 50;
      // Initialize pager and gets current page
      $page = pager_default_initialize($total_records, $num_per_page);
      $offset = ($page) * $num_per_page;
      $last = ($offset + $num_per_page < $total_records)? $offset + $num_per_page : $total_records;
      $header = array(
                       array('data' => t('List'), 'field' => 'list'),
                       array('data' => t('Size'), 'field' => 'size'),
                       array('data' => t('Mailable Size'), 'field' => 'm-size'),
                       array('data' => t('Last Modified'), 'field' => 'l-modified'),
                     );
      $email_list_table['header'] = $header;
      $email_list_table['attributes'] = array('class' => array('email-lists', 'va-table'));
      global $automatr_api_obj;
      $params = array('offset' => $offset, 'order_by' => $order_by, 'order_dir' => $sort, 'limit' => 50);
      $response = $automatr_api_obj->call_method('EmailList', 'getMultiple', $params);
      $render_array = volacci_pager_page_result(array('controller' => 'EmailList', 'response' => $response, 'last' => $last, 'table_params' => $email_list_table));
      // Calls Drupal standard pager theme and set 5 page links on pager
      $render_array .= theme('pager');
      $email_list .= $render_array;
    }
    else {
      $email_list .= t('No Lists.');
    }
  } catch (Exception $e) {
    drupal_set_message($e->getMessage(), 'error');
  }
  return $email_list;
}
