// $ID$

(function ($, Drupal, window, undefined) {

  /*
   * Add the automodal settings to the selectors.
   */
  Drupal.behaviors.automodal = function (context) {
    $.each(Drupal.settings.automodal, function(selector, settings) {
      $(selector +':not(.automodal-processed)', context)
        .addClass('automodal-processed')
        .bind('click', function() {
          settings.url = $(this).attr('href') || '#';
          if (settings.url.indexOf('?') >= 0) {
            settings.url += '&'
          }
          else {
            settings.url += '?'
          }
          settings.url += 'automodal=true';

          if (settings.automodalClose) {
            settings.url += '&automodalClose=true';
          }

          if (settings.automodalReload) {
            settings.url += '&automodalReload=true';
          }

          if (settings.automodalRedirect != undefined) {
            settings.url += '&automodalRedirect=' + encodeURIComponent(settings.automodalRedirect);
          }

          settings.onSubmit = Drupal.automodal.onSubmitCall;
          Drupal.modalFrame.open(settings);
          return false;
        });
    });
  }

  Drupal.automodal = Drupal.automodal || {};

  /**
   * Functions under Drupal.automodal.onSubmitCall are iterated over onSubmit
   * for the modalFrames when the window is set to close.
   */
  Drupal.automodal.onSubmitCallback = {
    automodal: function(args, statusMessages) {
      if (args.redirect) {
        window.location = decodeURIComponent(args.redirect);
      }

      if (args.reload) {
        window.location.reload();
      }
    }
  }

  Drupal.automodal.onSubmitCall = function(args, statusMessages) {
    for (var i in Drupal.automodal.onSubmitCallback) {
      Drupal.automodal.onSubmitCallback[i](args, statusMessages);
    }
  }
})(jQuery, Drupal, window);