<?php
/* ************************************************************************
   * This class is from Grant Hinkson (http://catalistcreative.com)
   * It is a derivitave of the Zend Article http://www.zend.com/zend/spotlight/creating-zip-files3.php
   * 
   * Class definition found at http://www.zend.com/zend/spotlight/creating-zip-files3.php
   * Some alterations to the original posted code were made in order to get everything working properly
   * See example usage at the bottom of this page
   * 
   * TODO: There are some inefficincies in this class, reduce them
   ************************************************************************
 */

class ZipFile 
{ 
  var $datasec = array(); 
  var $ctrl_dir = array(); 
  var $eof_ctrl_dir = "\x50\x4b\x05\x06\x00\x00\x00\x00"; 
  var $old_offset = 0;
  private $base_dir = '';
  
  function zipDir($path) {
    $this->base_dir = $path;
    $this->recHandleDir($path);
    return;
  }
  
  private function getRelPath($path) {
    return substr($path,strlen($this->base_dir)+1);
  }
  
  private function recHandleDir($path) {
    if(!is_dir($path)) {
      return;
    }
    
    $dir = scandir($path);
    
    foreach($dir as $k => $p) {
      if($p != '.' && $p != '..') {
        $this->recHandleFile("$path/$p");
      }
    }
    
  }
  private function recHandleFile($path) {
    if(is_dir($path)) {
      $this->add_dir($path);
      $this->recHandleDir($path);
      return;
    }
    // Else add to the file
    $this->add_file(file_get_contents($path), $this->getRelPath($path));
    return;
  }
  
  function add_dir($name) { 
    $name = str_replace("\\", "/", $name);
    $name = $this->getRelPath($name);
    
    $fr = "\x50\x4b\x03\x04"; 
    $fr .= "\x0a\x00"; 
    $fr .= "\x00\x00"; 
    $fr .= "\x00\x00"; 
    $fr .= "\x00\x00\x00\x00"; 
    
    $fr .= pack("V",0); 
    $fr .= pack("V",0); 
    $fr .= pack("V",0); 
    $fr .= pack("v", strlen($name) ); 
    $fr .= pack("v", 0 ); 
    $fr .= $name; 
    $fr .= pack("V", 0); 
    $fr .= pack("V", 0); 
    $fr .= pack("V", 0); 
    
    $this -> datasec[] = $fr;
    $new_offset = strlen(implode("", $this->datasec)); 
    
    $cdrec = "\x50\x4b\x01\x02"; 
    $cdrec .="\x00\x00"; 
    $cdrec .="\x0a\x00"; 
    $cdrec .="\x00\x00"; 
    $cdrec .="\x00\x00"; 
    $cdrec .="\x00\x00\x00\x00"; 
    $cdrec .= pack("V",0); 
    $cdrec .= pack("V",0); 
    $cdrec .= pack("V",0); 
    $cdrec .= pack("v", strlen($name) ); 
    $cdrec .= pack("v", 0 ); 
    $cdrec .= pack("v", 0 ); 
    $cdrec .= pack("v", 0 ); 
    $cdrec .= pack("v", 0 ); 
    $ext = "\x00\x00\x10\x00"; 
    $ext = "\xff\xff\xff\xff"; 
    $cdrec .= pack("V", 16 ); 
    $cdrec .= pack("V", $this -> old_offset ); 
    $cdrec .= $name; 
    
    $this -> ctrl_dir[] = $cdrec; 
    $this -> old_offset = $new_offset; 
    return; 
  } 
  
  function add_file($data, $name) { 
    $name = str_replace("\\", "/", $name); 
    $unc_len = strlen($data); 
    $crc = crc32($data); 
    $zdata = gzcompress($data); 
    $zdata = substr ($zdata, 2, -4); 
    $c_len = strlen($zdata); 
    $fr = "\x50\x4b\x03\x04"; 
    $fr .= "\x14\x00"; 
    $fr .= "\x00\x00"; 
    $fr .= "\x08\x00"; 
    $fr .= "\x00\x00\x00\x00"; 
    $fr .= pack("V",$crc); 
    $fr .= pack("V",$c_len); 
    $fr .= pack("V",$unc_len); 
    $fr .= pack("v", strlen($name) ); 
    $fr .= pack("v", 0 ); 
    $fr .= $name; 
    $fr .= $zdata; 
    $fr .= pack("V",$crc); 
    $fr .= pack("V",$c_len); 
    $fr .= pack("V",$unc_len); 
    
    $this -> datasec[] = $fr; 
    $new_offset = strlen(implode("", $this->datasec)); 
    
    $cdrec = "\x50\x4b\x01\x02"; 
    $cdrec .="\x00\x00"; 
    $cdrec .="\x14\x00"; 
    $cdrec .="\x00\x00"; 
    $cdrec .="\x08\x00"; 
    $cdrec .="\x00\x00\x00\x00"; 
    $cdrec .= pack("V",$crc); 
    $cdrec .= pack("V",$c_len); 
    $cdrec .= pack("V",$unc_len); 
    $cdrec .= pack("v", strlen($name) ); 
    $cdrec .= pack("v", 0 ); 
    $cdrec .= pack("v", 0 ); 
    $cdrec .= pack("v", 0 ); 
    $cdrec .= pack("v", 0 ); 
    $cdrec .= pack("V", 32 ); 
    $cdrec .= pack("V", $this -> old_offset ); 
    
    $this -> old_offset = $new_offset; 
    
    $cdrec .= $name; 
    $this -> ctrl_dir[] = $cdrec; 
  } 
  
  function file() { 
    $data = implode("", $this -> datasec); 
    $ctrldir = implode("", $this -> ctrl_dir); 
    
    return 
      $data . 
      $ctrldir . 
      $this -> eof_ctrl_dir . 
      pack("v", sizeof($this -> ctrl_dir)) . 
      pack("v", sizeof($this -> ctrl_dir)) . 
      pack("V", strlen($ctrldir)) . 
      pack("V", strlen($data)) . 
      "\x00\x00"; 
  } 
}






/**
* EasyZIP class version 1.0 stable
* replacement for class.filesplitter.php
* 14 October 2004
* zip & split on the fly
* Author: huda m elmatsani
* Email : justhuda ## netscape ## net
*
*
*  example
*  create zip file
*    $z = new EasyZIP;
*    $z -> addFile("map.bmp");
*    $z -> addFile("guide.pdf");
*      $z -> addDir("files/test");
*    $z -> zipFile("xyz.zip");
*
*  created splitted file
*      $z = new EasyZIP;
*      $z -> addFile("guide.pdf");
*    $z -> splitFile("map.zip",1048576);
*
*  pack and split
*      $z = new EasyZIP;
*    $z -> addFile("map.bmp");
*    $z -> addFile("guide.pdf");
*    $z -> splitFile("xyz.zip",1048576);
*
*
*/

//simple error message definition
define(FUNCTION_NOT_FOUND,'Error: gzcompress() function is not found');
define(FILE_NOT_FOUND,'Error: file is not found');
define(DIRECTORY_NOT_FOUND,'Error: directory is not found');

class EasyZIP {
    var $filelist = array();
    var $data_segments = array();
    var $data_block;
    var $file_headers  = array();
    var $filename;
    var $filedata;
    var $old_offset = 0;
    var $splitted = 0;
    var $split_signature = "";
    var $split_size = 1;
    var $split_offset = 0;
    var $disk_number = 1;
    var $path_sep = '\\';
    private $base_dir = '';

    function EasyZIP() {
        if (!@function_exists('gzcompress')) die(FUNCTION_NOT_FOUND);
    }

    function addFile($filename) {
        if(file_exists($filename)) {

            $this -> filelist[] = str_replace('\\', '/', $filename);

        } else {
            die(FILE_NOT_FOUND);
        }
    }

    function addDir($dirname, $recursive = false) {
        $this->base_dir = $dirname;
        if(!is_dir($dirname)) {
          return;
        }
        if($recursive) {
          
          if(is_dir($dirname)) {
            $scan = scandir($dirname);
            foreach($scan as $k => $file) {
              $file = trim($file);
              if($file == '.' || $file == '..') {
                continue;
              }
              if(is_dir($dirname . '/' . $file)) {
                $this->addDir($dirname . '/' . $file, true);
              }
              else {
                $this->addFile($dirname . '/' . $file);
              }
            }
          }
          
        }
        else {
        
          if ($handle = opendir($dirname)) {
          
             while (false !== ($filename = readdir($handle))) {
               if ($filename != "." && $filename != "..")
                    $this->addFile($dirname . '/' . $filename);
             }
          
             closedir($handle);
          } else {
              die(DIRECTORY_NOT_FOUND);
          }
        }
    }


    function zipFile($zipfilename) {
        $zip = $this -> packFiles();
        $fp = fopen($zipfilename, "w");
        fwrite($fp, $zip, strlen($zip));
        fclose($fp);
    }

    function splitFile($splitfilename, $chunk_size) {

        $this -> chunk_size = $chunk_size;
        $this -> splitted = 1;
        $this -> split_offset = 4;
        $this -> old_offset = $this -> split_offset;
        $this -> split_signature = "\x50\x4b\x07\x08";

        $zip = $this -> packFiles();

        $out = $this -> str_split($this -> split_signature . $zip, $chunk_size);

        for ($i = 0; $i < sizeof($out); $i++){
            if($i < sizeof($out)-1) {
                $sfilename = basename ($splitfilename,".zip");
                $sfilename = $sfilename . ".z" . sprintf("%02d",$i+1);
            }
            else $sfilename = $splitfilename;
            $fp = fopen($sfilename, "w");
            fwrite($fp, $out[$i], strlen($out[$i]));
            fclose($fp);
        }

    }



    function packFiles() {

        foreach($this -> filelist as $k => $filename) {
            $this -> filename =  $filename;
            $this -> setFileData();
            $this -> setLocalFileHeader();
            $this -> setDataDescriptor();
            $this -> setDataSegment();
            $this -> setFileHeader();
        }
        return  $this -> getDataSegments() .
                $this -> getCentralDirectory();

    }

    function setFileData() {
            clearstatcache();
            $fd = fopen ($this->filename, "rb");
            $this->filedata = fread ($fd, filesize ($this->filename));
            fclose ($fd);
            $filetime = filectime($this->filename);
            $this -> DOSFileTime($filetime);

    }

    function setLocalFileHeader() {

        $local_file_header_signature           = "\x50\x4b\x03\x04";//4 bytes  (0x04034b50)
        $this -> version_needed_to_extract      = "\x14\x00";  //2 bytes
        $this -> general_purpose_bit_flag      = "\x00\x00";  //2 bytes
        $this -> compression_method           = "\x08\x00";  //2 bytes
        $this -> crc_32                          = pack('V', crc32($this -> filedata));//  4 bytes
                //compressing data
                $c_data   = gzcompress($this -> filedata);
                $this->compressed_filedata    = substr(substr($c_data, 0, strlen($c_data) - 4), 2); // fix crc bug
        
        $this -> compressed_size                = pack('V', strlen($this -> compressed_filedata));// 4 bytes
        $this -> uncompressed_size              = pack('V', strlen($this -> filedata));//4 bytes
        $this -> filename_length              = pack('v', strlen($this -> filename));// 2 bytes
        $this -> extra_field_length           = pack('v', 0);  //2 bytes

        $this -> local_file_header =     $local_file_header_signature .
                $this -> version_needed_to_extract .
                $this -> general_purpose_bit_flag .
                $this -> compression_method .
                $this -> last_mod_file_time .
                $this -> last_mod_file_date .
                $this -> crc_32 .
                $this -> compressed_size .
                $this -> uncompressed_size .
                $this -> filename_length .
                $this -> extra_field_length .
                $this -> filename;

        
    }

    function setDataDescriptor() {
    
        $this -> data_descriptor =  $this->crc_32 .   //4 bytes
                $this -> compressed_size .           //4 bytes
                $this -> uncompressed_size;          //4 bytes
    }

    function setDataSegment() {
    
            $this -> data_segments[]     =     $this -> local_file_header .
                                    $this -> compressed_filedata .
                                    $this -> data_descriptor;
            $this -> data_block = implode('', $this -> data_segments);
    }

    function getDataSegments() {
        return $this -> data_block;
    }

    function setFileHeader() {

        $new_offset        = strlen( $this -> split_signature . $this -> data_block );
        
        $central_file_header_signature  = "\x50\x4b\x01\x02";//4 bytes  (0x02014b50)
        $version_made_by                = pack('v', 0);  //2 bytes
        
        $file_comment_length            = pack('v', 0);  //2 bytes
        $disk_number_start              = pack('v', $this -> disk_number - 1); //2 bytes
        $internal_file_attributes       = pack('v', 0); //2 bytes
        $external_file_attributes       = pack('V', 32); //4 bytes
        $relative_offset_local_header   = pack('V', $this -> old_offset); //4 bytes
        
        if($this -> splitted) {
            $this -> disk_number = ceil($new_offset/$this->chunk_size);
            $this -> old_offset = $new_offset - ($this->chunk_size * ($this -> disk_number-1));
        } else $this -> old_offset = $new_offset;
        
        $this -> file_headers[] =     $central_file_header_signature .
                $version_made_by .
                $this -> version_needed_to_extract .
                $this -> general_purpose_bit_flag .
                $this -> compression_method .
                $this -> last_mod_file_time .
                $this -> last_mod_file_date .
                $this -> crc_32 .
                $this -> compressed_size .
                $this -> uncompressed_size .
                $this -> filename_length .
                $this -> extra_field_length .
                $file_comment_length .
                $disk_number_start .
                $internal_file_attributes .
                $external_file_attributes .
                $relative_offset_local_header .
                $this -> filename;
    }

    function getCentralDirectory() {
        $this -> central_directory = implode('', $this -> file_headers);
        return  $this -> central_directory .
                $this -> getEndCentralDirectory();
    }

    function getEndCentralDirectory() {
                    
        $zipfile_comment = "Compressed/Splitted by PHP EasyZIP";

        if($this -> splitted) {
            $data_len = strlen($this -> split_signature . $this -> data_block . $this -> central_directory);
            $last_chunk_len = $data_len - floor($data_len / $this -> chunk_size) * $this -> chunk_size;
            $this -> old_offset = $last_chunk_len - strlen($this -> central_directory);
        }

        $end_central_dir_signature    = "\x50\x4b\x05\x06";//4 bytes  (0x06054b50)
        $number_this_disk             = pack('v', $this->disk_number - 1);//2 bytes
        $number_disk_start              = pack('v', $this->disk_number - 1);//  2 bytes
        $total_number_entries          = pack('v', sizeof($this -> file_headers));//2 bytes
        $total_number_entries_central = pack('v', sizeof($this -> file_headers));//2 bytes
        $size_central_directory         = pack('V', strlen($this -> central_directory));  //4 bytes
        
        $offset_start_central         = pack('V', $this -> old_offset); //4 bytes     
        $zipfile_comment_length       = pack('v', strlen($zipfile_comment));//2 bytes
        
        return $end_central_dir_signature .
            $number_this_disk .
            $number_disk_start .
            $total_number_entries .
            $total_number_entries_central .
            $size_central_directory .
            $offset_start_central .
            $zipfile_comment_length .
            $zipfile_comment;
    }

    function DOSFileTime($unixtime = 0) {
        $timearray = ($unixtime == 0) ? getdate() : getdate($unixtime);

        if ($timearray['year'] < 1980) {
            $timearray['year']    = 1980;
            $timearray['mon']     = 1;
            $timearray['mday']    = 1;
            $timearray['hours']   = 0;
            $timearray['minutes'] = 0;
            $timearray['seconds'] = 0;
        }

        $dostime = (($timearray['year'] - 1980) << 25) |
                    ($timearray['mon'] << 21) | ($timearray['mday'] << 16) |
                    ($timearray['hours'] << 11) | ($timearray['minutes'] << 5) |
                    ($timearray['seconds'] >> 1);
                
        $dtime    = dechex($dostime);
        $hexdtime = '\x' . $dtime[6] . $dtime[7]
                  . '\x' . $dtime[4] . $dtime[5];
                  
        $hexddate = '\x' . $dtime[2] . $dtime[3]
                  . '\x' . $dtime[0] . $dtime[1];
        eval('$hexdtime = "' . $hexdtime . '";');
        eval('$hexddate = "' . $hexddate . '";');
        
        $this->last_mod_file_time = $hexdtime;
        $this->last_mod_file_date = $hexddate;
    }     
    function str_split($string, $length) {
        for ($i = 0; $i < strlen($string); $i += $length) {
            $array[] = substr($string, $i, $length);
        }
        return $array;
    }

}

