<?php

/**
 * Views handler to filter on availability.
 */
class availability_calendar_handler_filter_availability extends views_handler_filter_date {
  function option_definition() {
    $options = parent::option_definition();

    $options['operator'] = array('default' => 'between');
    $options['exposed'] = array('default' => TRUE);

    return $options;
  }

  function operators() {
    // We only allow "available at <date>" and
    // "available between <from> and <to>" as operators.
    $operators = array(
      '=' => array(
        'title' => t('At (date)'),
        'method' => 'op_simple',
        'short' => t('at'),
        'values' => 1,
      ),
      'between' => array(
        'title' => t('Between'),
        'method' => 'op_between',
        'short' => t('between'),
        'values' => 2,
      ),
    );

    return $operators;
  }

  /**
   * Add a type selector to the value form
   */
  function value_form(&$form, &$form_state) {
    parent::value_form($form, $form_state);
    // We reverse the option that date filter added to define dates relatively.
    if (empty($form_state['exposed'])) {
      $form['value']['type']['#type'] = 'hidden';
      $form['value']['type']['#default_value'] = 'date';
      $form['value']['type']['#access'] = FALSE;  // Don't send to the client.
    }
  }

  /**
   * Validate that the time values convert to something usable.
   */
  function validate_valid_time(&$form, $operator, $value) {
    // @todo: for now use parent implementation, but evntually I think we should
    //   restrict to dates only not date-times.
    parent::validate_valid_time($form, $operator, $value);
  }

  function accept_exposed_input($input) {
    // @todo: for now use parent implementation but eventually I think we will
    //   integrate the at and between operators and let it depend on whether the
    //   2nd operand has been filled in or not.
    return parent::accept_exposed_input($input);
  }

  function op_between($field) {
    module_load_include('inc', 'availability_calendar', 'availability_calendar.widget');
    availability_calendar_query_available($this->query, $this->table_alias, $this->field, new DateTime($this->value['min']), new DateTime($this->value['max']), $this->definition['default_state']);
  }

  function op_simple($field) {
    $this->value['min'] = $this->value['max'] = $this->value['value'];
    return $this->op_between($field);
  }
}
