(function($) {
  "use strict";

  /**
   * Initialization code based on the Drupal behaviors paradigm.
   *
   * This behavior turns date fields to search on availability in a Views
   * exposed form into a date range picker.
   */
  Drupal.behaviors.availabilityCalendarHandlerFilterAvailability = {
    attach: function(context, settings) {
      if (settings.datePopup) {
        // Find date field pairs to turn into a date range picker.
        for (var id in settings.datePopup) {
          if (settings.datePopup.hasOwnProperty(id)) {
            var from = $("#" + id + "[data-date-range-end]", context);
            if (from.length > 0) {
              var fromName = from.attr("name");
              var toName = fromName.replace("[from]", "[" + from.attr("data-date-range-end") + "]");
              var selector = "[name='" + toName + "']";
              var to = $("[name='" + toName + "']", context);
              if (to.length > 0) {
                // Turn into a date range picker.
                Drupal.availabilityCalendar.dateRangePicker(from[0], to[0]);
              }
            }
          }
        }
      }
    }
  };

}(jQuery));
