
/**
 * bind event when you need, 
 * do it in custom code
 */
Drupal.behaviors.avatar_uploader = function(context) {
  if (Drupal.settings.avatar_uid) {
    var el = $('.profile .picture a');
    if (el.size()) {
      el.click(
        function() {
          au.show(Drupal.settings.avatar_uid);
          return false;
        }
      );

      au.Events.submit._update_img = function(res) {
        el.find('img').attr('src', Drupal.settings.basePath + res.new_avatar);
      }
    }
  }
}


$.fn.centerMe = function() {
    this.css({
        'position': 'fixed',
        'left': '50%',
        'top': '50%'
    });
    this.css({
        'margin-left': -this.outerWidth() / 2 + 'px',
        'margin-top': -this.outerHeight() / 2 + 'px'
    });
    return this;
}
au = {
  panel:   null,
  
  Events: {
    upload: {},
    submit: {},
    cancel: {},
    presubmit: {},
    dosubmit: {}
  },
  
  //css options for panel
  _options: {},
  _uid : null,
  
  setup: function(uid, options) {
    if (!au.panel) {
      au._options = options;
      au._uid = uid;
      au.panel = $('<div class="avatar_uploader" />').css($.extend({'z-index': 999}, au._options)).appendTo($('body')).centerMe();
    }
  },
  
  show: function(uid, options) {
    if (uid) {
      au.setup(uid, options);
    }
    
    if (!au._uid) {
      au._uid = Drupal.settings.avatar_uid;
    }
    
    if (!au.panel.html()) {
      $.post(Drupal.settings.basePath + 'au/panel', {uid: au._uid}, function(res) {
        au.panel.html(res).centerMe();
      });
    }
    
    au.panel.centerMe().show('fast');
  },
  
  close: function() {
    au.panel.hide('fast');
  },
  
  trigger: function(name, param) {
    if (name == 'dosubmit' || name == 'cancel') {
      //close panel
      au.close();
    }
    
    //trigger event
    jQuery.each(au.Events[name], function(){
      this(param);
    });
  }
};
