<?php

/**
 * @file
 * Contains \Drupal\ak\Annotation\AvatarGenerator.
 */

namespace Drupal\ak\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines an annotation for AvatarGenerator plugins.
 *
 * @Annotation
 */
class AvatarGenerator extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The human-readable name of the plugin.
   *
   * @ingroup plugin_translatable
   *
   * @var \Drupal\Core\Annotation\Translation
   */
  public $label;

  /**
   * The weight of the plugin.
   *
   * @var int
   */
  public $weight;

  /**
   * The description of the avatar generator.
   *
   * @ingroup plugin_translatable
   *
   * @var \Drupal\Core\Annotation\Translation
   */
  public $description;

  /**
   * Whether the avatar generated by generator can change.
   *
   * @var bool
   */
  public $dynamic = FALSE;

  /**
   * Whether the generator will always produce an avatar.
   *
   * @var bool
   */
  public $fallback = FALSE;

  /**
   * Defines the source of the avatar.
   *
   * Whether the generator produces a URI for downloading the avatar (uses
   * generateUri method). Otherwise the file is already local (use getFile
   * method).
   *
   * @var bool
   */
  public $remote = FALSE;

}
