<?php

namespace Drupal\avif\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Class SettingsForm.
 */
class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'avif.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'avif_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('avif.settings');

    $form['endpoint'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Service Endpoint'),
      '#default_value' => $config->get('endpoint'),
      '#description' => $this->t('The URL endpoint of the Avif conversion service.'),
      '#required' => TRUE,
      '#size' => 250,
      '#maxlength' => 250,
    ];

    $form['quality'] = [
      '#type' => 'number',
      '#title' => $this->t('Image quality'),
      '#description' => $this->t('Specify the image quality. This setting
       will be in effect for all new image style derivatives. In order to apply
       this setting to existing image style derivatives, flush image styles
       through the interface, or by using Drush or Drupal Console.'),
      '#default_value' => $config->get('quality'),
      '#min' => 1,
      '#max' => 100,
    ];
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    parent::validateForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);

    $this->config('avif.settings')
      ->set('quality', (int)$form_state->getValue('quality'))
      ->set('endpoint', (string)$form_state->getValue('endpoint'))
      ->save();
  }

}
