<?php

namespace Drupal\awareness\Entity;

use Drupal\Core\Entity\EntityTypeManagerInterface;

/**
 * Interface for classes that utilize entity_type.manager service.
 */
interface EntityTypeManagerAwareInterface {

  /**
   * Set the entity type manager.
   *
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entityTypeManager
   *   The entity type manager service.
   *
   * @return $this
   */
  public function setEntityTypeManager(EntityTypeManagerInterface $entityTypeManager);

}
