<?php

namespace Drupal\awareness\Entity;

use Drupal\Core\Entity\EntityTypeManagerInterface;

/**
 * Trait for classes that utilize entity_type.manager service.
 */
trait EntityTypeManagerAwareTrait {

  /**
   * The entity type manager service.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * @see \Drupal\awareness\Entity\EntityTypeManagerAwareInterface::setEntityTypeManager
   */
  public function setEntityTypeManager(EntityTypeManagerInterface $entityTypeManager) {
    $this->entityTypeManager = $entityTypeManager;
  }

}
