<?php

namespace Drupal\awareness\Cache;

use Drupal\Core\Cache\CacheFactoryInterface;

/**
 * Interface for classes that utilize cache.factory service.
 */
interface CacheFactoryAwareInterface {

  const SERVICE_ID = 'cache.factory';

  /**
   * Set the cache factory service.
   *
   * @param \Drupal\Core\Cache\CacheFactoryInterface $cacheFactory
   *   The cache factory service.
   *
   * @return $this
   */
  public function setCacheFactory(CacheFactoryInterface $cacheFactory);

}
