<?php

namespace Drupal\awareness\Cache;

use Drupal\Core\Cache\CacheFactoryInterface;

/**
 * Trait for classes that utilize cache.factory service.
 */
trait CacheFactoryAwareTrait {

  /**
   * Cache factory service.
   *
   * @var \Drupal\Core\Cache\CacheFactoryInterface
   */
  protected $cacheFactory;

  /**
   * @see \Drupal\awareness\Cache\CacheFactoryAwareInterface::setCacheFactory
   */
  public function setCacheFactory(CacheFactoryInterface $cacheFactory) {
    $this->cacheFactory = $cacheFactory;
    return $this;
  }

  /**
   * Returns the requested cache bin.
   *
   * @param string $bin
   *   (optional) The cache bin for which the cache object should be returned,
   *   defaults to 'default'.
   *
   * @return \Drupal\Core\Cache\CacheBackendInterface
   *   The cache object associated with the specified bin.
   */
  protected function getCacheBin($bin = 'default') {
    return $this->cacheFactory->get($bin);
  }

}
