<?php

namespace Drupal\awareness\Context;

use Drupal\Core\Plugin\Context\ContextRepositoryInterface;

/**
 * Interface for classes that utilize context.repository service.
 */
interface ContextRespositoryAwareInterface {

  const SERVICE_ID = 'context.repository';

  /**
   * Set the context repository service.
   *
   * @param \Drupal\Core\Plugin\Context\ContextRepositoryInterface $contextRepository
   *   The context repository service.
   *
   * @return $this
   */
  public function setContextRepository(ContextRepositoryInterface $contextRepository);

}
