<?php

namespace Drupal\awareness\Context;

use Drupal\Core\Entity\Plugin\DataType\EntityAdapter;
use Drupal\Core\Plugin\Context\ContextRepositoryInterface;

/**
 * Trait for classes that utilize context.repository service.
 */
trait ContextRespositoryAwareTrait {

  /**
   * The context repository service.
   *
   * @var \Drupal\Core\Plugin\Context\ContextRepositoryInterface
   */
   protected $contextRepository;

  /**
   * @see \Drupal\awareness\Context\ContextRespositoryAwareInterface::setContextRepository
   */
  public function setContextRepository(ContextRepositoryInterface $contextRepository) {
    $this->contextRepository = $contextRepository;
    return $this;
  }

  /**
   * Get a value from context.
   *
   * @param string $context_id
   *   The context ID.
   *
   * @return \Drupal\Core\Plugin\Context\ContextInterface|null
   *   The context, or NULL if not available.
   */
  protected function getContextValue($context_id) {
    $contexts = $this->contextRepository->getRuntimeContexts([$context_id]);
    return $contexts[$context_id] ?? NULL;
  }

  /**
   * Get the entity value from a context.
   *
   * @param string $context_id
   *   The context ID.
   *
   * @return \Drupal\Core\Entity\EntityInterface|null
   *   The entity, or NULL if not available.
   */
  protected function getContextEntityValue($context_id) {
    $data = $this->getContextValue($context_id)->getContextData();
    return $data instanceof EntityAdapter ? $data->getEntity() : NULL;
  }

}
