<?php

namespace Drupal\awareness\Extension;

use Drupal\Core\Extension\ModuleHandlerInterface;

/**
 * Interface for classes that utilize module_handler service.
 */
interface ModuleHandlerAwareInterface {

  const SERVICE_ID = 'module_handler';

  /**
   * Set the module handler.
   *
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $moduleHandler
   *   The module handler service.
   *
   * @return $this
   */
  public function setModuleHandler(ModuleHandlerInterface $moduleHandler);

}
