<?php

namespace Drupal\awareness\Extension;

use Drupal\Core\Extension\ModuleHandlerInterface;

/**
 * Trait for classes that utilize module_handler service.
 */
trait ModuleHandlerAwareTrait {

  /**
   * The module handler service.
   *
   * @var \Drupal\Core\Extension\ModuleHandlerInterface
   */
  protected $moduleHandler;

  /**
   * @see \Drupal\awareness\Extension\ModuleHandlerAwareInterface::setModuleHandler
   */
  public function setModuleHandler(ModuleHandlerInterface $moduleHandler) {
    $this->moduleHandler = $moduleHandler;
    return $this;
  }

}
