<?php

namespace Drupal\awareness\Http;

use GuzzleHttp\ClientInterface;

/**
 * Trait for classes that utilize the http_client service.
 */
trait HttpClientAwareTrait {

  /**
   * The HTTP client service.
   *
   * @var \GuzzleHttp\ClientInterface
   */
  protected $httpClient;

  /**
   * @see \Drupal\awareness\KeyValue\HttpClientAwareInterface::setHttpClient
   */
  public function setHttpClient(ClientInterface $httpClient) {
    $this->httpClient = $httpClient;
  }

}
