<?php

namespace Drupal\awareness\KeyValue;

use Drupal\Core\KeyValueStore\KeyValueFactoryInterface;

/**
 * Interface for classes that utilize the keyvalue service.
 */
interface KeyValueFactoryAwareInterface {

  const SERVICE_ID = 'keyvalue';

  /**
   * Set the key value factory.
   *
   * @param \Drupal\Core\KeyValueStore\KeyValueFactoryInterface $keyValueFactory
   *   The key value factory service.
   *
   * @return $this
   */
  public function setKeyValueFactory(KeyValueFactoryInterface $keyValueFactory);

}
