<?php

namespace Drupal\awareness\KeyValue;

use Drupal\Core\KeyValueStore\KeyValueFactoryInterface;

/**
 * Trait for classes that utilize the keyvalue service.
 */
trait KeyValueFactoryAwareTrait {

  /**
   * The key value factory service.
   *
   * @var \Drupal\Core\KeyValueStore\KeyValueFactoryInterface
   */
  protected $keyValueFactory;

  /**
   * @see \Drupal\awareness\KeyValue\KeyValueFactoryAwareInterface::setKeyValueFactory
   */
  public function setKeyValueFactory(KeyValueFactoryInterface $keyValueFactory) {
    $this->keyValueFactory = $keyValueFactory;
    return $this;
  }

}
