<?php

namespace Drupal\awareness\Request;

use Symfony\Component\HttpFoundation\RequestStack;

/**
 * Interface for classes that utilize request_stack service.
 */
interface RequestStackAwareInterface {

  const SERVICE_ID = 'request_stack';

  /**
   * Set the request stack.
   *
   * @param \Symfony\Component\HttpFoundation\RequestStack $requestStack
   *   The request stack.
   *
   * @return $this
   */
  public function setRequestStack(RequestStack $requestStack);

}
