<?php

namespace Drupal\awareness\Request;

use Symfony\Component\HttpFoundation\RequestStack;

/**
 * Trait for classes that utilize request_stack service.
 */
trait RequestStackAwareTrait {

  /**
   * The request stack.
   *
   * @var \Symfony\Component\HttpFoundation\RequestStack
   */
  protected $requestStack;

  /**
   * @see \Drupal\awareness\Request\RequestStackAwareInterface::setRequestStack
   */
  public function setRequestStack(RequestStack $requestStack) {
    $this->requestStack = $requestStack;
    return $this;
  }

}
