<?php

namespace Drupal\awareness\Settings;

use Drupal\Core\Site\Settings;

/**
 * Interface for classes that utilize the settings service.
 */
interface SettingsAwareInterface {

  const SERVICE_ID = 'settings';

  /**
   * Set the settings service.
   *
   * @param \Drupal\Core\Site\Settings $settings
   *   The settings service.
   *
   * @return $this
   */
  public function setConfigFactory(Settings $settings);

}
