<?php

namespace Drupal\awareness\Settings;

use Drupal\Core\Site\Settings;

/**
 * Trait for classes that utilize the settings service.
 */
trait SettingsAwareTrait {

  /**
   * Settings service.
   *
   * @var \Drupal\Core\Site\Settings
   */
  protected $settings;

  /**
   * @see \Drupal\awareness\Settings\SettingsAwareInterface::setConfigFactory
   */
  public function setSettings(Settings $settings) {
    $this->settings = $settings;
    return $this;
  }

}
