<?php

namespace Drupal\awareness\Uuid;

use Drupal\Component\Uuid\UuidInterface;

/**
 * Interface for classes that utilize the uuid service.
 */
interface UuidAwareInterface {

  const SERVICE_ID = 'uuid';

  /**
   * Set the uuid service.
   *
   * @param \Drupal\Component\Uuid\UuidInterface $uuid
   *   The uuid service.
   *
   * @return $this
   */
  public function setUuid(UuidInterface $uuid);

}
