<?php

namespace Drupal\awareness\Uuid;

use Drupal\Component\Uuid\UuidInterface;

/**
 * Trait for classes that utilize the uuid service.
 */
trait UuidAwareTrait {

  /**
   * UUID service.
   *
   * @var \Drupal\Component\Uuid\UuidInterface
   */
  protected $uuid;

  /**
   * @see \Drupal\awareness\Uuid\UuidAwareInterface::setUuid
   */
  public function setUuid(UuidInterface $uuid) {
    $this->uuid = $uuid;
    return $this;
  }

}
