<?php

namespace Drupal\awareness\Database;

use Drupal\Core\Database\Connection;

/**
 * Trait for classes that utilize database service.
 */
trait DatabaseAwareTrait {

  /**
   * The database connection.
   *
   * @var \Drupal\Core\Database\Connection
   */
  protected $database;

  /**
   * @see \Drupal\awareness\Database\DatabaseAwareInterface::setDatabase
   */
  public function setDatabase(Connection $database) {
    $this->database = $database;
    return $this;
  }

}
