<?php

namespace Drupal\awareness\DateTime;

use Drupal\Component\Datetime\TimeInterface;

/**
 * Interface for classes that utilize datetime.time service.
 */
interface TimeAwareInterface {

  const SERVICE_ID = 'datetime.time';

  /**
   * Set the time service.
   *
   * @param \Drupal\Component\Datetime\TimeInterface $time
   *   The time service.
   *
   * @return $this
   */
  public function setTime(TimeInterface $time);

}
