<?php

namespace Drupal\awareness\Http;

use GuzzleHttp\ClientInterface;

/**
 * Interface for classes that utilize the http_client service.
 */
interface HttpClientAwareInterface {

  const SERVICE_ID = 'http_client';

  /**
   * Set the HTTP client service.
   *
   * @param \GuzzleHttp\ClientInterface $httpClient
   *   The HTTP client service.
   *
   * @return $this
   */
  public function setHttpClient(ClientInterface $httpClient);

}
