<?php

namespace Drupal\awareness\KeyValue;

use Drupal\Core\KeyValueStore\KeyValueExpirableFactoryInterface;

/**
 * Trait for classes that utilize the keyvalue.expirable service.
 */
trait KeyValueExpirableFactoryAwareTrait {

  /**
   * The key value expirable factory service.
   *
   * @var \Drupal\Core\KeyValueStore\KeyValueExpirableFactoryInterface
   */
  protected $keyValueExpirableFactory;

  /**
   * @see \Drupal\awareness\KeyValue\KeyValueExpirableFactoryAwareInterface::setKeyValueExpirableFactory
   */
  public function setKeyValueExpirableFactory(KeyValueExpirableFactoryInterface $keyValueExpirableFactory) {
    $this->keyValueExpirableFactory = $keyValueExpirableFactory;
    return $this;
  }

}
