<?php

namespace Drupal\awareness\Routing;

use Drupal\Core\Routing\RouteMatchInterface;

/**
 * Trait for classes that utilize current_route_match service.
 */
trait RouteMatchAwareTrait {

  /**
   * The current route match.
   *
   * @var \Drupal\Core\Routing\RouteMatchInterface
   */
  protected $routeMatch;

  /**
   * @see \Drupal\awareness\Routing\RouteMatchAwareInterface::setRouteMatch
   */
  public function setRouteMatch(RouteMatchInterface $routeMatch) {
    $this->routeMatch = $routeMatch;
    return $this;
  }

}
