<?php

namespace Drupal\awareness\Database;

use Drupal\Core\Database\Connection;

/**
 * Interface for classes that utilize database service.
 */
interface DatabaseAwareInterface {

  const SERVICE_ID = 'database';

  /**
   * Set the database service.
   *
   * @param \Drupal\Core\Database\Connection $database
   *   The config factory service.
   *
   * @return $this
   */
  public function setDatabase(Connection $database);

}
