<?php

namespace Drupal\awareness\DateTime;

use Drupal\Core\Datetime\DateFormatterInterface;

/**
 * Trait for classes that utilize date.formatter service.
 */
trait DateFormatterAwareTrait {

  /**
   * Date formatter service.
   *
   * @var \Drupal\Core\Datetime\DateFormatterInterface
   */
  protected $dateFormatter;

  /**
   * @see \Drupal\awareness\DateTime\DateFormatterAwareInterface::setDateFormatter
   */
  public function setDateFormatter(DateFormatterInterface $dateFormatter) {
    $this->dateFormatter = $dateFormatter;
    return $this;
  }

}
