<?php

namespace Drupal\awareness\Event;

use Symfony\Component\EventDispatcher\EventDispatcherInterface;

/**
 * Interface for classes that utilize event_dispatcher service.
 */
interface EventDispatcherAwareInterface {

  const SERVICE_ID = 'event_dispatcher';

  /**
   * Set the event dispatcher.
   *
   * @param \Symfony\Component\EventDispatcher\EventDispatcherInterface $eventDispatcher
   *   The event dispatcher.
   *
   * @return $this
   */
  public function setEventDispatcher(EventDispatcherInterface $eventDispatcher);

}
