<?php

namespace Drupal\awareness\File;

use Drupal\Core\File\FileSystemInterface;

/**
 * Trait for classes that utilize file_system service.
 */
trait FileSystemAwareTrait {

  /**
   * The file system service.
   *
   * @var \Drupal\Core\File\FileSystemInterface $fileSystem
   */
  protected $fileSystem;

  /**
   * @see \Drupal\awareness\File\FileSystemAwareInterface::setFileSystem
   */
  public function setFileSystem(FileSystemInterface $fileSystem) {
    $this->fileSystem = $fileSystem;
    return $this;
  }

}
