<?php

namespace Drupal\awareness\Http;

use Drupal\Core\Http\ClientFactory;

/**
 * Trait for classes that utilize the http_client_factory service.
 */
trait HttpClientFactoryAwareTrait {

  /**
   * The HTTP client factory service.
   *
   * @var \Drupal\Core\Http\ClientFactory
   */
  protected $httpClientFactory;

  /**
   * @see \Drupal\awareness\Http\HttpClientFactoryAwareInterface::setHttpClientFactory
   */
  public function setHttpClientFactory(ClientFactory $httpClientFactory) {
    $this->httpClientFactory = $httpClientFactory;
  }

}
