<?php

namespace Drupal\awareness\KeyValue;

use Drupal\Core\KeyValueStore\KeyValueExpirableFactoryInterface;

/**
 * Interface for classes that utilize the keyvalue.expirable service.
 */
interface KeyValueExpirableFactoryAwareInterface {

  const SERVICE_ID = 'keyvalue.expirable';

  /**
   * Set the key value factory.
   *
   * @param \Drupal\Core\KeyValueStore\KeyValueExpirableFactoryInterface $keyValueExpirableFactory
   *   The key value expirable factory service.
   *
   * @return $this
   */
  public function setKeyValueExpirableFactory(KeyValueExpirableFactoryInterface $keyValueExpirableFactory);

}
