<?php

namespace Drupal\awareness\Password;

use Drupal\Core\Password\PasswordGeneratorInterface;

/**
 * Interface for classes that utilize password_generator service.
 */
interface PasswordGeneratorAwareInterface {

  const SERVICE_ID = 'password_generator';

  /**
   * Set the password generator.
   *
   * @param \Drupal\Core\Password\PasswordGeneratorInterface $passwordGenerator
   *   The password generator service.
   *
   * @return $this
   */
  public function setPasswordGenerator(PasswordGeneratorInterface $passwordGenerator);

}
