<?php

namespace Drupal\awareness\Password;

use Drupal\Core\Password\PasswordGeneratorInterface;

/**
 * Trait for classes that utilize password_generator service.
 */
trait PasswordGeneratorAwareTrait {

  /**
   * The password generator service.
   *
   * @var \Drupal\Core\Password\PasswordGeneratorInterface
   */
  protected $passwordGenerator;

  /**
   * @see \Drupal\awareness\Password\PasswordGeneratorAwareInterface::setPasswordGenerator
   */
  public function setPasswordGenerator(PasswordGeneratorInterface $passwordGenerator) {
    $this->passwordGenerator = $passwordGenerator;
    return $this;
  }

}
