<?php

namespace Drupal\awareness\Render;

use Drupal\Core\Render\RendererInterface;

/**
 * Interface for classes that utilize renderer service.
 */
interface RendererAwareInterface {

  const SERVICE_ID = 'renderer';

  /**
   * Set the renderer.
   *
   * @param \Drupal\Core\Render\RendererInterface $renderer
   *   The renderer service.
   *
   * @return $this
   */
  public function setRenderer(RendererInterface $renderer);

}
