<?php

namespace Drupal\awareness\Routing;

use Drupal\Core\Routing\RedirectDestinationInterface;

/**
 * Interface for classes that utilize redirect.destination service.
 */
interface RedirectDestinationAwareInterface {

  const SERVICE_ID = 'redirect.destination';

  /**
   * Set the redirect destination.
   *
   * @param \Drupal\Core\Routing\RedirectDestinationInterface $redirectDestination
   *   The redirect destination service.
   *
   * @return $this
   */
  public function setRedirectDestination(RedirectDestinationInterface $redirectDestination);

}
