<?php

namespace Drupal\awareness\Routing;

use Drupal\Core\Routing\RedirectDestinationInterface;

/**
 * Trait for classes that utilize redirect.destination service.
 */
trait RedirectDestinationAwareTrait {

  /**
   * The redirect destination service.
   *
   * @var \Drupal\Core\Routing\RedirectDestinationInterface
   */
  protected $redirectDestination;

  /**
   * @see \Drupal\awareness\Routing\RedirectDestinationAwareInterface::setRedirectDestination
   */
  public function setRedirectDestination(RedirectDestinationInterface $redirectDestination) {
    $this->redirectDestination = $redirectDestination;
    return $this;
  }

}
