<?php

namespace Drupal\awareness\Session;

use Drupal\Core\Session\AccountInterface;

/**
 * Interface for classes that utilize current_user service.
 */
interface CurrentUserAwareInterface {

  const SERVICE_ID = 'current_user';

  /**
   * Set the current user.
   *
   * @param \Drupal\Core\Session\AccountInterface $currentUser
   *   The current user.
   *
   * @return $this
   */
  public function setCurrentUser(AccountInterface $currentUser);

}
