<?php

namespace Drupal\awareness\Session;

use Drupal\Core\Session\AccountInterface;

/**
 * Trait for classes that utilize current_user service.
 */
trait CurrentUserAwareTrait {

  /**
   * The current user.
   *
   * @var \Drupal\Core\Session\AccountInterface
   */
  protected $currentUser;

  /**
   * @see \Drupal\awareness\Session\CurrentUserAwareInterface::setCurrentUser
   */
  public function setCurrentUser(AccountInterface $currentUser) {
    $this->currentUser = $currentUser;
    return $this;
  }

}
