<?php

namespace Drupal\awareness\Config;

use Drupal\Core\Config\ConfigFactoryInterface;

/**
 * Interface for classes that utilize config.factory service.
 */
interface ConfigFactoryAwareInterface {

  const SERVICE_ID = 'config.factory';

  /**
   * Set the config factory service.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   *   The config factory service.
   *
   * @return $this
   */
  public function setConfigFactory(ConfigFactoryInterface $configFactory);

}
