<?php

namespace Drupal\awareness\Config;

use Drupal\Core\Config\ConfigFactoryInterface;

/**
 * Trait for classes that utilize config.factory service.
 */
trait ConfigFactoryAwareTrait {

  /**
   * Config factory service.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * @see \Drupal\awareness\Config\ConfigFactoryAwareInterface::setConfigFactory
   */
  public function setConfigFactory(ConfigFactoryInterface $configFactory) {
    $this->configFactory = $configFactory;
    return $this;
  }

  /**
   * Load a config object.
   *
   * @param string $name
   *   The name of the configuration object.
   *
   * @return \Drupal\Core\Config\ImmutableConfig
   *   The config object.
   */
  protected function getConfig($name) {
    return $this->configFactory->get($name);
  }

  /**
   * Load an editable config object.
   *
   * @param string $name
   *   The name of the configuration object.
   *
   * @return \Drupal\Core\Config\Config
   *   The editable config object.
   */
  protected function getEditableConfig($name) {
    return $this->configFactory->getEditable($name);
  }

}
