<?php

namespace Drupal\awareness\Controller;

use Drupal\Core\Controller\ControllerResolverInterface;

/**
 * Interface for classes that utilize controller_resolver service.
 */
interface ControllerResolverAwareInterface {

  const SERVICE_ID = 'controller_resolver';

  /**
   * Set the controller resolver.
   *
   * @param \Drupal\Core\Controller\ControllerResolverInterface $controllerResolver
   *   The controller resolver service.
   *
   * @return $this
   */
  public function setControllerResolver(ControllerResolverInterface $controllerResolver);

}
