<?php

namespace Drupal\awareness\Controller;

use Drupal\Core\Controller\ControllerResolverInterface;

/**
 * Trait for classes that utilize controller_resolver service.
 */
trait ControllerResolverAwareTrait {

  /**
   * The controller resolver service.
   *
   * @var \Drupal\Core\Controller\ControllerResolverInterface
   */
  protected $controllerResolver;

  /**
   * @see \Drupal\awareness\Controller\ControllerResolverAwareInterface::setControllerResolver
   */
  public function setControllerResolver(ControllerResolverInterface $controllerResolver) {
    $this->controllerResolver = $controllerResolver;
    return $this;
  }

}
