<?php

namespace Drupal\awareness\Entity;

use Drupal\Core\Entity\EntityRepositoryInterface;

/**
 * Interface for classes that utilize entity.repository service.
 */
interface EntityRepositoryAwareInterface {

  const SERVICE_ID = 'entity.repository';

  /**
   * Set the entity repository.
   *
   * @param EntityRepositoryInterface $entityRepository
   *   The entity repository service.
   *
   * @return $this
   */
  public function setEntityRepository(EntityRepositoryInterface $entityRepository);

}
