<?php

namespace Drupal\awareness\Entity;

use Drupal\Core\Entity\EntityRepositoryInterface;

/**
 * Trait for classes that utilize entity.repository service.
 */
trait EntityRepositoryAwareTrait {

  /**
   * The entity repository service.
   *
   * @var \Drupal\Core\Entity\EntityRepositoryInterface
   */
  protected $entityRepository;

  /**
   * @see \Drupal\awareness\Entity\EntityRepositoryAwareInterface::setEntityRepository
   */
  public function setEntityRepository(EntityRepositoryInterface $entityRepository) {
    $this->entityRepository = $entityRepository;
    return $this;
  }

}
